// Franzis - Programmieren mit KI - Bausatz - Niklas Heinzel - 2025
// 5_Wetterstation-Skript

#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <DHT.h>

// OLED Display Einstellungen
#define SCREEN_WIDTH 128 // Breite des OLED-Displays in Pixeln
#define SCREEN_HEIGHT 64 // Höhe des OLED-Displays in Pixeln
#define OLED_RESET -1    // Kein separater Reset-Pin nötig, wird auf -1 ge-setzt
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET); // OLED-Display-Objekt erstellen

// DHT11-Sensor-Einstellungen
#define DHTPIN 2        // Daten-Pin des DHT11-Sensors ist an Pin D2 ange-schlossen
#define DHTTYPE DHT11   // Typ des Sensors: DHT11
DHT dht(DHTPIN, DHTTYPE); // DHT-Sensorobjekt erstellen

// Fototransistor-Einstellungen
#define LDR_PIN A2   // Analoger Pin, an dem der Fototransistor angeschlos-sen ist

// Potenziometer-Einstellungen
#define POT_PIN A0   // Analoger Pin, an dem das Potenziometer für den Grenzwert angeschlossen ist

// RGB-LED-Einstellungen (Common Anode)
#define RED_PIN 3    // Pin für den roten Kanal
#define GREEN_PIN 4  // Pin für den grünen Kanal
#define BLUE_PIN 5   // Pin für den blauen Kanal

// Buzzer-Einstellung
#define BUZZER_PIN 6 // Pin, an dem der Buzzer angeschlossen ist

// Startup-Icon (Franzis-Logo) (128x64 Pixel) - Eigene Bitmap unter https://javl.github.io/image2cpp/ erstellen
const unsigned char logo[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0xcf, 0xf8, 0x00, 0xf8, 0x0f, 0x07, 0x8f, 0xff, 0x3e, 0x03, 0xf8, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0xdf, 0xff, 0x01, 0xf8, 0x0f, 0x87, 0xcf, 0xff, 0x3e, 0x1f, 0xfe, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0xdf, 0xff, 0x81, 0xfc, 0x0f, 0xc7, 0x8f, 0xff, 0x3e, 0x3f, 0xfc, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x1f, 0x83, 0xfc, 0x0f, 0xe7, 0x80, 0x3e, 0x3e, 0x3e, 0x08, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x0f, 0x83, 0xfe, 0x0f, 0xe7, 0x80, 0x7c, 0x3e, 0x3f, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0x9f, 0x3f, 0x87, 0xfe, 0x0f, 0xf7, 0x80, 0xfc, 0x3e, 0x3f, 0xf0, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0x9f, 0xff, 0x07, 0xde, 0x0f, 0xff, 0x81, 0xf8, 0x3e, 0x3f, 0xfc, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0x9f, 0xfc, 0x07, 0x9f, 0x0f, 0xff, 0x83, 0xf0, 0x3e, 0x0f, 0xfe, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x7c, 0x0f, 0xff, 0x0f, 0x7f, 0x87, 0xe0, 0x3e, 0x00, 0xff, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x3e, 0x0f, 0xff, 0x8f, 0x3f, 0xcf, 0xc0, 0x3e, 0x00, 0x3f, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x3f, 0x1f, 0xff, 0x8f, 0x3f, 0xcf, 0xc0, 0x3e, 0x38, 0x7e, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x1f, 0x9f, 0x0f, 0xcf, 0x1f, 0x9f, 0xff, 0x3e, 0x7f, 0xfc, 0x00, 0x00, 
	0x00, 0x00, 0xf8, 0x1f, 0x0f, 0xbe, 0x07, 0xcf, 0x0f, 0x9f, 0xff, 0x3e, 0x7f, 0xf8, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// Beispiel-Icons (8x8 Pixel)
const unsigned char thermometerIcon[] PROGMEM = {
  0x18, 0x3C, 0x3C, 0x18, 0x18, 0x18, 0x7E, 0x00
};

const unsigned char humidityIcon[] PROGMEM = {
  0x18, 0x3C, 0x7E, 0x7E, 0x7E, 0x3C, 0x18, 0x00
};

const unsigned char lightIcon[] PROGMEM = {
  0x24, 0x18, 0x7E, 0x18, 0x24, 0x42, 0x81, 0x00
};

// Aktualisierungsintervall für die Messungen
unsigned long previousMillis = 0; // Speichert den Zeitpunkt der letzten Aktualisierung
const long interval = 2000; // Zeitintervall zwischen zwei Messungen (in Millisekunden)

void setup() {
  // Serielle Kommunikation starten
  Serial.begin(115200);

  // OLED Display initialisieren
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Initialisierung des OLED-Displays mit der I2C-Adresse 0x3C
    Serial.println(F("SSD1306 allocation failed")); // Fehlerausgabe, wenn das Display nicht initialisiert werden konnte
    for (;;); // Endlosschleife bei Fehler
  }

  // Display löschen und Logo anzeigen
  display.clearDisplay(); // Display leeren
  display.drawBitmap(0, 0, logo, SCREEN_WIDTH, SCREEN_HEIGHT, WHITE); // Logo zeichnen
  display.display(); // Inhalte auf dem Display anzeigen
  delay(5000); // 3 Sekunden warten

  // Nach der Anzeige des Logos Display löschen
  display.clearDisplay();
  display.display();

  // DHT11 Sensor initialisieren
  dht.begin();

  // Fototransistor-Pin als Eingang definieren
  pinMode(LDR_PIN, INPUT);

  // RGB-LED-Pins als Ausgang definieren
  pinMode(RED_PIN, OUTPUT);
  pinMode(GREEN_PIN, OUTPUT);
  pinMode(BLUE_PIN, OUTPUT);

  // Buzzer-Pin als Ausgang definieren
  pinMode(BUZZER_PIN, OUTPUT);

  // Alle RGB-LED-Farben und den Buzzer initial ausschalten
  setRGBColor(0, 0, 0); // RGB-LED aus
  digitalWrite(BUZZER_PIN, LOW); // Buzzer aus
}

void loop() {
  unsigned long currentMillis = millis();

  // Überprüfen, ob das Intervall seit der letzten Aktualisierung abgelaufen ist
  if (currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis; // Zeitpunkt der letzten Aktualisierung speichern

    // Temperatur, Luftfeuchtigkeit und Helligkeit lesen
    float temperature = dht.readTemperature(); // Temperatur (in °C) auslesen
    float humidity = dht.readHumidity();       // Luftfeuchtigkeit (in %) auslesen
    int ldrValue = analogRead(LDR_PIN);        // Helligkeitswert vom Fototransistor auslesen

    // Grenzwert für die Helligkeit vom Potenziometer auslesen
    int potValue = analogRead(POT_PIN);                  // Potenziometerwert (0–1023) auslesen
    int lightThreshold = map(potValue, 0, 1023, 0, 100); // Grenzwert auf den Bereich 0–100 skalieren

    // Helligkeitswert skalieren (0–100%)
    int brightness = map(ldrValue, 0, 1023, 0, 100);

    // Überprüfen, ob die Messdaten gültig sind
    if (isnan(temperature) || isnan(humidity)) {
      Serial.println(F("Fehler beim Lesen des DHT11-Sensors!")); // Fehlermeldung ausgeben

      // Fehler auf dem OLED-Display anzeigen
      display.clearDisplay();
      display.setCursor(0, 0);
      display.println(F("DHT Fehler!"));
      display.display();
      return;
    }

    // Sensorwerte auf dem seriellen Monitor ausgeben
    Serial.print(F("Temperatur: "));
    Serial.print(temperature, 1); // Temperaturwert ausgeben (1 Dezimalstelle)
    Serial.print(F(" °C, Luftfeuchtigkeit: "));
    Serial.print(humidity, 1);    // Luftfeuchtigkeit ausgeben
    Serial.print(F(" %, Helligkeit: "));
    Serial.print(brightness);     // Helligkeit ausgeben
    Serial.print(F(" %, Grenzwert: "));
    Serial.print(lightThreshold); // Grenzwert der Helligkeit ausgeben
    Serial.println(F(" %"));

    // Display aktualisieren
    display.clearDisplay();

    // Titelzeile
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.setCursor(25, 0);
    display.print(F("Wetterstation"));
    display.drawLine(0, 9, 127, 9, WHITE);

    // Temperatur anzeigen mit Icon
    display.drawBitmap(0, 13, thermometerIcon, 8, 8, WHITE);
    display.setCursor(12, 13);
    display.print(F("Temperatur: "));
    display.print(temperature, 1);
    display.print(" "); // Leerzeichen hinzufügen
    int xCircle = display.getCursorX() + 2; // X-Position für den Kreis (Gradzeichen)
    int yCircle = 13; // Y-Position für den Kreis
    display.drawCircle(xCircle, yCircle + 2, 2, WHITE); // Gradzeichen als Kreis zeichnen
    display.setCursor(display.getCursorX() + 6, 13); // Weiter hinter dem Kreis
    display.print(F("C")); // Einheit "C" (Celsius)

    // Luftfeuchtigkeit anzeigen mit Icon
    display.drawBitmap(0, 26, humidityIcon, 8, 8, WHITE);
    display.setCursor(12, 26);
    display.print(F("Luftfeuchte: "));
    display.print(humidity, 1);
    display.print(F(" %"));

    // Helligkeit anzeigen mit Fortschrittsbalken und Grenzwert
    display.drawBitmap(0, 39, lightIcon, 8, 8, WHITE);
    display.setCursor(12, 39);
    display.print(F("Helligkeit: "));
    display.print(brightness);
    display.print(F(" %"));

    // Fortschrittsbalken zeichnen
    display.drawRect(0, 50, 128, 10, WHITE); // Rahmen
    display.fillRect(0, 50, map(brightness, 0, 100, 0, 128), 10, WHITE); // Füllbalken

    // Grenzwert als vertikalen Strich im Fortschrittsbalken anzeigen
    int thresholdX = map(lightThreshold, 0, 100, 0, 128); // Grenzwert auf Pixelbreite skalieren
    display.drawLine(thresholdX, 50, thresholdX, 60, WHITE); // Vertikalen Strich zeichnen

    display.display();

    // RGB LED und Buzzer basierend auf den Bedingungen steuern
    if (temperature > 25 || humidity > 80 || brightness > lightThreshold) { // Bedingung: Temperatur, Luftfeuchtigkeit oder Helligkeit zu hoch
      setRGBColor(255, 0, 0); // Rot für kritische Bedingungen
      tone(BUZZER_PIN, 1000, 500); // Buzzer piept (Frequenz: 1000 Hz, Dauer: 500 ms)
    } else if (temperature >= 20 && temperature <= 25) {
      setRGBColor(0, 255, 0); // Grün für moderat
      digitalWrite(BUZZER_PIN, LOW); // Buzzer aus
    } else {
      setRGBColor(0, 0, 255); // Blau für kalt
      digitalWrite(BUZZER_PIN, LOW); // Buzzer aus
    }
  }
}

// Funktion zur Steuerung der RGB-LED für Common Anode
void setRGBColor(int red, int green, int blue) {
  // Werte invertieren, da Common Anode verwendet wird
  analogWrite(RED_PIN, 255 - red);
  analogWrite(GREEN_PIN, 255 - green);
  analogWrite(BLUE_PIN, 255 - blue);
}
